unit IWCompButtonWAP;

interface

uses
  {$IFDEF VSNET}
  System.ComponentModel, System.Drawing, IWNETBaseControl,
  {$ENDIF}
  Classes, IWControlWAP, IWBaseWAPInterfaces, IWBaseControl, IWBaseRenderContext, IWWapTag,
  IWBaseComponent, IWBaseInterfaces, IWMarkupLanguageTag, IWTypes, IWBaseWapControl,
  IWWAPRenderContext, IWBaseForm;

type
  TIWXHTMLMPButtonType = (btSubmit, btReset);

  TIWCustomButtonWAP = class(TIWCustomControlWAP, IIWSubmitControl)
  protected
    FSubmitParam: string;
    FButtonType: TIWXHTMLMPButtonType;

    procedure Submit(const AValue: string); override;
    procedure InitControl; override;
    {$IFDEF VSNET}
    function getText: string; reintroduce;virtual;
    procedure setText(AValue: string); reintroduce;virtual;
    {$ENDIF}
    function GEtSubmitParam: string;
  public
    function RenderWap(AContext: TIWBaseWapComponentContext): TIWWapTag; override;

    {$IFDEF VSNET}
    property Text: string read getText write setText;
    {$ENDIF}
    property ButtonType: TIWXHTMLMPButtonType read FButtonType write FButtonType;
  end;

  {$IFDEF VSNET}
  {$R icons\Atozed.Intraweb.TIWButtonWAP.bmp}
  TIWButtonWAP = class;
  [ToolboxItem(true), ToolboxBitmap(typeof(TIWButtonWAP), 'TIWButtonWAP.bmp')]
  {$ENDIF}
  TIWButtonWAP = class(TIWCustomButtonWAP)
  published
    {$IFDEF VSNET}
    property Text;
    {$ELSE}
    property Caption;
    {$ENDIF}
    property OnClick;
    property ButtonType;
    property Enabled;
  end;


implementation

uses
  SysUtils, SWSystem, IWGlobal;

{ TIWCustomButtonWAP }

{$IFDEF VSNET}
function TIWCustomButtonWAP.getText: string;
begin
  Result := Caption;
end;

procedure TIWCustomButtonWAP.setText(AValue: string);
begin
  Caption := AValue;
  TIWNETBaseControl(Self).Invalidate;
end;
{$ENDIF}

procedure TIWCustomButtonWAP.InitControl;
begin
  inherited;

  Height := 25;
  Width := 75;
end;

function TIWCustomButtonWAP.RenderWap(
  AContext: TIWBaseWapComponentContext): TIWWapTag;
var
  LAction: string;
  LForm: TIWBaseForm;
  LGo: TIWWAPTag;
  LPOstTag: TIWWAPTag;
begin
  if AContext.PageContext.OutputTagType = wotWML then begin
    Result := TIWWAPTag.CreateTag('do');
    try
      Result.AddStringParam('type', 'accept');
      Result.AddStringParam('label', Caption);
      Result.AddStringParam('name', ComponentName);
      LForm := TIWBaseForm(AContext.WebApplication.ActiveForm);
      LAction := LForm.FormAction;
      LGo := TIWWAPTag.CreateTag('go');
      if GServerController.CharSet <> '' then begin
        LGo.AddStringPAram('accept-charset', GServerController.CharSet);
      end;
      LGo.AddStringParam('href', LAction + '/' + IntToStr(AContext.WebApplication.TrackId) + '/' + AContext.WebApplication.AppID);
      LGo.AddStringParam('method', 'post');
      LPostTag := TIWWAPTag.CreateWAPTag('postfield', cbSimpleClose);
      with LPostTag do begin
        AddStringParam('name', 'IW_Action');
        AddStringParam('value', ComponentName);
      end;
      LGo.Contents.AddTagAsObject(LPostTag);
      LPostTag := TIWWAPTag.CreateWAPTag('postfield', cbSimpleClose);
      with LPostTag do begin
        AddStringParam('name', 'IW_FormName');
        if Self.Name = '' then begin
          Self.Name := 'noname';
        end;
        AddStringParam('value', LForm.Name);
      end;
      LGo.Contents.AddTagAsObject(LPostTag);
      LPostTag := TIWWAPTag.CreateWAPTag('postfield', cbSimpleClose);
      with LPostTag do begin
        AddStringParam('name', 'IW_FormClass');
        {$IFDEF VSNET}
        AddStringParam('value', self.GetType.FullName);
        {$ELSE}
        AddStringParam('value', LForm.ClassName);
        {$ENDIF}
      end;
      LGo.Contents.AddTagAsObject(LPostTag);

      AddSessionFields(LGo,AContext);      

      LGo.Contents.AddText('{$FORMTAG$}');
      Result.Contents.AddTagAsObject(LGo);
    except
       FreeAndNil(Result);
       raise;
    end;
  end else if AContext.PageContext.OutputTagType = wotXHTMLMP then begin
    Result := TIWWAPTag.CreateTag('input');
    try
      case ButtonType of
        btSubmit: Result.AddStringParam('type', 'submit');
        btReset: Result.AddStringParam('type', 'reset');
      end;
      Result.AddStringParam('name', Self.Name);
      Result.AddStringParam('value', TextToXHTMLMP(Caption));
      if not Enabled then begin
        Result.Add('disabled');
      end;
    except
      FreeAndNil(Result);
      raise;
    end;
  end else begin
    Result := inherited RenderWaP(AContext);
  end

end;

procedure TIWCustomButtonWAP.Submit(const AValue: string);
begin
  FSubmitParam := AValue;
  DoClick;
end;

function TIWCustomButtonWAP.GetSubmitParam: string;
begin
  Result := FSubmitParam;
end;
end.
